// Universal ID Collector - Background Script (ОПТИМИЗИРОВАННЫЙ)
console.log('🚀 Universal ID Collector background script loaded (оптимизированный модульный сервер)');

// Единый обработчик сообщений
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    console.log('📨 Background received message:', request.action);
    
    switch (request.action) {
        case 'extensionInitialized':
            console.log(`✅ Расширение инициализировано на ${request.site}`);
            console.log('📊 API статус:', request.apiStatus);
            break;
            
        case 'parsersUpdated':
        case 'settingsUpdated':
            // Пересылаем в popup если открыт
            chrome.runtime.sendMessage(request).catch(error => {
                if (!error.message.includes('Receiving end does not exist')) {
                    console.warn('❌ Error forwarding to popup:', error);
                }
            });
            break;
            
        case 'showNotification':
        case 'toggleAutoScan':
        case 'rescanPage':
            // Пересылаем в активную вкладку
            chrome.tabs.query({ active: true, currentWindow: true }).then(tabs => {
                if (tabs[0]?.id) {
                    chrome.tabs.sendMessage(tabs[0].id, request).catch(error => {
                        if (!error.message.includes('Receiving end does not exist')) {
                            console.warn('❌ Error forwarding to tab:', error);
                        }
                    });
                }
            });
            break;
            
        case 'checkServer':
            // Пересылаем в active tab для проверки
            chrome.tabs.query({ active: true, currentWindow: true }).then(tabs => {
                if (tabs[0]?.id) {
                    chrome.tabs.sendMessage(tabs[0].id, request, (response) => {
                        if (response) {
                            sendResponse(response);
                        }
                    });
                }
            });
            return true; // Важно для асинхронного ответа
    }
    
    // Не держим соединение открытым для синхронных сообщений
    if (request.action !== 'checkServer') {
        return false;
    }
});

// Обработчик установки
chrome.runtime.onInstalled.addListener((details) => {
    console.log('✅ Extension installed/updated:', details.reason);
    
    if (details.reason === 'install') {
        // Устанавливаем настройки по умолчанию
        chrome.storage.local.set({
            enabled: true,
            firstInstall: true
        });
    }
});

console.log('✅ Background script ready');
